import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/blocs/popular_articles_bloc.dart';
import 'package:wordpress_app/cards/card1.dart';
import 'package:wordpress_app/pages/popular_articles_page.dart';
import 'package:wordpress_app/utils/loading_card.dart';
import '../utils/next_screen.dart';
import 'package:easy_localization/easy_localization.dart';

class PopularArticles extends ConsumerWidget {
  const PopularArticles({super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    PopularArticlesBloc pb = ref.watch(popularArticlesBlocProvider);
    
    // Hide widget if no contents and data has been loaded
    if (pb.articles.isEmpty && !pb.hasData) {
      return const SizedBox.shrink();
    }
    
    return Padding(
      padding: const EdgeInsets.all(20),
      child: Column(
        children: [
          Row(
            children: [
              Text(
                'popular-contents',
                style: Theme.of(context)
                    .textTheme
                    .headlineSmall
                    ?.copyWith(fontWeight: FontWeight.w700),
              ).tr(),
              const Spacer(),
              TextButton(
                child: const Text(
                  'view-all',
                  style: TextStyle(fontSize: 14),
                ).tr(),
                onPressed: () {
                  nextScreenPopup(context, const PopularArticlesPage());
                },
              )
            ],
          ),
          ListView.separated(
            physics: const NeverScrollableScrollPhysics(),
            shrinkWrap: true,
            padding: const EdgeInsets.only(top: 5, bottom: 15),
            itemCount: pb.articles.isEmpty ? 3 : pb.articles.length,
            separatorBuilder: (context, index) => const Divider(height: 40),
            itemBuilder: (BuildContext context, int index) {
              if (pb.articles.isEmpty) {
                return const LoadingCard(
                  height: 200,
                );
              } else {
                return Card1(
                  article: pb.articles[index],
                  heroTag: 'popular_${pb.articles[index].id}',
                );
              }
            },
          )
        ],
      ),
    );
  }
}
